package w83a.w83aBeans;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aDAO.w83aConstantesBD.W83aFasesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aImpugnacionesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aPreavisosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aTramitesBD;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aDocBeanImpug.
 */
public class W83aDocBeanImpug extends W83aBaseBean implements W83aBaseBeanBD{

	/** The id. */
	public String id="";
	
	/** The nombre. */
	private String nombre="";
	
	/** The tipo documento. */
	private String tipoDocumento="";
	
	/** The fecha registro. */
	private String fechaRegistro="";
	
	/** The numero registro. */
	private String numeroRegistro="";
	
	/** The usuario. */
	private String usuario="";
	
	/** The file data. */
	private InputStream fileData;
	
	/** The file data blob. */
	private Blob fileDataBlob;
	
	/** The cod fase. */
	private String codFase;
	
	/** The desc fase. */
	private String descFase;
	
	/** The dese fase. */
	private String deseFase;
	
	/** The cod tramite. */
	private String codTramite;
	
	/** The desc tramite. */
	private String descTramite;
	
	/** The dese tramite. */
	private String deseTramite;
	
	/** The desc tipo. */
	private String descTipo;
	
	/** The dese tipo. */
	private String deseTipo;
	
	/** The tamanyo. */
	private int tamanyo;
	
	
	/**
	 * Sets the tamanyo.
	 * 
	 * @param tamanyo the new tamanyo
	 */
	public void setTamanyo (int tamanyo)
	{
		this.tamanyo=tamanyo;
	}
	
	/**
	 * Gets the tamanyo.
	 * 
	 * @return the tamanyo
	 */
	public int getTamanyo ()
	{
		return this.tamanyo;
	}
	
	/**
	 * Gets the file data.
	 * 
	 * @return the file data
	 */
	public InputStream getFileData()
	{
		return this.fileData;
	}
	
	/**
	 * Sets the file data.
	 * 
	 * @param fileData the new file data
	 */
	public void setFileData (InputStream fileData)
	{
		this.fileData=fileData;
	}
	
	/**
	 * Gets the usuario.
	 * 
	 * @return the usuario
	 */
	public String getUsuario() {
		return usuario;
	}
	
	/**
	 * Sets the usuario.
	 * 
	 * @param usuario the new usuario
	 */
	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}
	
	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombre() {
		return nombre;
	}
	
	/**
	 * Sets the nombre.
	 * 
	 * @param nombre the new nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}
	
	/**
	 * Gets the tipo documento.
	 * 
	 * @return the tipo documento
	 */
	public String getTipoDocumento() {
		return tipoDocumento;
	}
	
	/**
	 * Sets the tipo documento.
	 * 
	 * @param tipoDocumento the new tipo documento
	 */
	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}
	
	/**
	 * Gets the fecha registro.
	 * 
	 * @return the fecha registro
	 */
	public String getFechaRegistro() {
		return fechaRegistro;
	}
	
	/**
	 * Sets the fecha registro.
	 * 
	 * @param fechaRegistro the new fecha registro
	 */
	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
	
	/**
	 * Gets the numero registro.
	 * 
	 * @return the numero registro
	 */
	public String getNumeroRegistro() {
		return numeroRegistro;
	}
	
	/**
	 * Sets the numero registro.
	 * 
	 * @param numeroRegistro the new numero registro
	 */
	public void setNumeroRegistro(String numeroRegistro) {
		this.numeroRegistro = numeroRegistro;
	}
	
	/**
	 * Row to bean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		this.id=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.id_docu_041);
		this.fileDataBlob=W83aDataBase.getBlobFromRS(rs, W83aImpugnacionesBD.docu_041);
		this.nombre=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.nomb_docu_041);
		this.tipoDocumento=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.tp_doc_041);
		
		this.fechaRegistro=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.f_reg_041);
		
		this.descTipo=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.desc_cas_069);
		this.deseTipo=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.desc_eus_069);
		this.numeroRegistro=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.num_reg_041);
		this.usuario=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.usuario_041);
		
		this.codTramite=W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.c_tram_041);
		this.descTramite=W83aDataBase.getStringFromRS(rs, W83aTramitesBD.nomTramite_Cast);
		this.deseTramite=W83aDataBase.getStringFromRS(rs, W83aTramitesBD.nomTramite_Eusk);
		this.descFase=W83aDataBase.getStringFromRS(rs, W83aFasesBD.descripcion);
		this.deseFase=W83aDataBase.getStringFromRS(rs, W83aFasesBD.descripcion_eusk);
		return this;
	}

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 * 
	 * @param id the new id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the file data blob.
	 * 
	 * @return the file data blob
	 */
	public Blob getFileDataBlob() {
		return fileDataBlob;
	}

	/**
	 * Sets the file data blob.
	 * 
	 * @param fileDataBlob the new file data blob
	 */
	public void setFileDataBlob(Blob fileDataBlob) {
		this.fileDataBlob = fileDataBlob;
	}

	/**
	 * Gets the cod fase.
	 * 
	 * @return the cod fase
	 */
	public String getCodFase() {
		return codFase;
	}

	/**
	 * Sets the cod fase.
	 * 
	 * @param codFase the new cod fase
	 */
	public void setCodFase(String codFase) {
		this.codFase = codFase;
	}

	/**
	 * Gets the cod tramite.
	 * 
	 * @return the cod tramite
	 */
	public String getCodTramite() {
		return codTramite;
	}

	/**
	 * Sets the cod tramite.
	 * 
	 * @param codTramite the new cod tramite
	 */
	public void setCodTramite(String codTramite) {
		this.codTramite = codTramite;
	}

	/**
	 * Gets the desc tipo.
	 * 
	 * @return the desc tipo
	 */
	public String getDescTipo() {
		return descTipo;
	}

	/**
	 * Sets the desc tipo.
	 * 
	 * @param descTipo the new desc tipo
	 */
	public void setDescTipo(String descTipo) {
		this.descTipo = descTipo;
	}

	/**
	 * Gets the dese tipo.
	 * 
	 * @return the dese tipo
	 */
	public String getDeseTipo() {
		return deseTipo;
	}

	/**
	 * Sets the dese tipo.
	 * 
	 * @param deseTipo the new dese tipo
	 */
	public void setDeseTipo(String deseTipo) {
		this.deseTipo = deseTipo;
	}

	public String getDescTramite() {
		return descTramite;
	}

	public void setDescTramite(String descTramite) {
		this.descTramite = descTramite;
	}

	public String getDeseTramite() {
		return deseTramite;
	}

	public void setDeseTramite(String deseTramite) {
		this.deseTramite = deseTramite;
	}

	public String getDescFase() {
		return descFase;
	}

	public void setDescFase(String descFase) {
		this.descFase = descFase;
	}

	public String getDeseFase() {
		return deseFase;
	}

	public void setDeseFase(String deseFase) {
		this.deseFase = deseFase;
	}

	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombrePartido() {
		StringBuffer nombrePartido = new StringBuffer();
		
		if(null!=this.nombre && this.nombre.length()>20){
			nombrePartido = new StringBuffer();
			String nombreTemp = this.nombre;
			while(nombreTemp.length()>0){
				int tamanyo = nombreTemp.length();
				if(tamanyo>20){
					tamanyo=20;
				}
				nombrePartido.append(nombreTemp.substring(0, tamanyo)).append(" ");
				nombreTemp = nombreTemp.substring(tamanyo);
			}
		}else{
			nombrePartido = new StringBuffer(this.nombre);
		}
		
		return nombrePartido.toString();
	}
	
	
}
